package examples.entity.uni.many_to_one;

import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import examples.entity.uni.many_to_one.interfaces.EmployeeAddressMOUni;

@Stateless
public class EmployeeAddressMOUniBean implements EmployeeAddressMOUni {
	@PersistenceContext
	EntityManager em;

	public void doSomeStuff() {
		BusinessAddress a = new BusinessAddress();
		a.setCity("Huntington Station");
		a.setZipcode("11746");
		
		Employee e = new Employee();
		e.setName("Micah Silverman");
		e.setAddress(a);
		em.persist(e);
		
		e = new Employee();
		e.setName("Tes Silverman");
		e.setAddress(a);
		em.persist(e);
		
		e = new Employee();
		e.setName("Shaina Silverman");
		e.setAddress(a);
		em.persist(e);
	}

	public List getEmployees() {
		Query q = em.createQuery("SELECT e FROM Employee e");
		return q.getResultList();
	}
}
